TITLE   'Simultaneous Electric and Thermal Conduction'  	{ exa171.pde }
SELECT     					{ Student Edition }
   errlim=1e-5     spectral_colors
COORDINATES
   cartesian1					{ 1D calculation }
VARIABLES   U    temp			{ Two dependent variables }
DEFINITIONS
   Lx=1.0     temp0=300     U1=-0.2
   cond0=1/1.67e-8     cond=cond0*temp0/temp     k=400    { Copper }
   Ex=-dx(U)     Jx=cond*Ex
   fluxd_x=-k*dx( temp)
INITIAL VALUES
   U=U1*x/Lx   temp=300
EQUATIONS
   U:		dx( Jx)= 0     		{ U is the only dependent variable }
   temp:	dx( fluxd_x)=Jx*Ex   	{ Variable temp is dominant }
BOUNDARIES
region 'domain'
   start (0) point value(U)=0  point value(temp)=300
   line to (Lx)  point value(U)=U1  point value(temp)=300
PLOTS
   elevation( temp) from (0) to (Lx)     elevation( fluxd_x) from (0) to (Lx)
   elevation( U) from (0) to (Lx)     elevation( Ex) from (0) to (Lx)
   elevation( Jx) from (0) to (Lx)
END


